from omegaconf import DictConfig, OmegaConf
import datetime,os

def initialize_wandb(args):
    wdb_run = None
    if len(args.wandb_log) > 0:
        # train.py
        import wandb

        wandb.login()

        epochs = 10
        lr = 0.01
        try:
            os.makedirs(args.alt_path)
        except OSError as e:
            pass
        print(args.alt_path)
        wdb_run = wandb.init(
            # Set the project where this run will be logged
            project=args.wandb_log,
            name=args.run_name + "_" + str(datetime.datetime.now().time()),
            # Track hyperparameters and run metadata
            config=OmegaConf.to_container(args),
            dir = args.alt_path,
            id=args.run_name + "_" + str(datetime.datetime.now().time()).replace(":", "_"),
            # Track hyperparameters and run metadata
        )
    return wdb_run
